/*******************************************************************************
*
* Hy8513.h - Header file for the Hytec 8513 IP cards
*
********************************************************************************
*
* CHANGE HISTORY
*
*   25-JUNE-2004 Paul Hamadyk DLS Ltd
*      Initial Version.
*
*******************************************************************************/

/* 
$Id: Hy8513.h,v 1.2 2005/02/02 10:57:49 cross Exp $
*/

/* Driver Initialisation Defines */
#define DRIVER_INIT Hy8513Init
#define IO_REPORT   DrvHy8513Report
#define DRV         drvHy8513
#define LIST        Hy8513List
#define CONFIGURE   Hy8513Configure


/* * DRV driver error codes */
#define M_drvLib (1003<<16U)
#define drvError(CODE) (M_drvLib | (CODE))

#define S_drv_OK 0			            /* success */
#define S_drv_badParam drvError(1)	    /* driver: bad parameter */
#define S_drv_noMemory drvError(2)	    /* driver: no memory */
#define S_drv_noDevice drvError(3)	    /* driver: device not configured */
#define S_drv_invSigMode drvError(4)	/* driver: signal mode conflicts with device config */
#define S_drv_cbackChg drvError(5)	    /* driver: specified callback differs from previous config */
#define S_drv_alreadyQd drvError(6)	    /* driver: a read request is already queued for the channel */
