/********************************************************************************/
/*    H   H Y   Y TTTTT EEEEE  CCC       HYTEC ELECTRONICS LTD                  */
/*    H   H  Y Y    T   E     C          5 Cradock Road,                        */
/*    HHHHH   Y     T   EEE   C          Reading, Berks.    Tel: 0118 9757770   */
/*    H   H   Y     T   E     C          RG2 0JT            Fax: 0118 9757566   */
/*    H   H   Y     T   EEEEE  CCC       Web: www.hytec-electronics.co.uk       */
/********************************************************************************/

/* $Author: cross $ */
/* $Date: 2004/11/18 12:59:35 $ */
/* $Id: devHy8513.c,v 1.2 2004/11/18 12:59:35 cross Exp $ */
/* $Name:  $ */
/* $Revision: 1.2 $ */

/********************************************************************************/
/*                                                                              */
/*  devHy8513.c - Device Support for the Hytec 8513 IP cards                    */
/*                                                                              */
/*  (C)2004 Hytec Electronics Ltd.                                              */
/*                                                                              */
/********************************************************************************/
/*                                                                              */
/*  Revision history: (comment and initial revisions)                           */
/*                                                                              */
/*  vers.       revised         modified by                                     */
/*  -----       -----------     -------------------------                       */
/*  See Above.  18-NOV-2004     Darrell Nineham Hytec Electronics Ltd.          */
/*								1. Fixed bug (found by Paul Hamadyk) rounding   */
/*								   rval in read_ai().                           */
/*								2. Fixed bug (found by Paul Hamadyk) must       */
/*								   return 0 to allow conversion by EGUF and     */
/*								   EGUL in read_ai().                           */
/*                              3. Upgraded to Hytec coding standard.           */
/*                                                                              */
/*  1.1         25-JUN-2004     Paul Hamadyk DLS Ltd                            */
/*	                            Example device support for a Hytec Hy8513 IP    */
/*								module. Initial Version.                        */ 
/*                                                                              */
/********************************************************************************/
#include <vxWorks.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include	<aiRecord.h>
#include	<aoRecord.h>
#include	<biRecord.h>
#include	<boRecord.h>
#include	<mbbiRecord.h>
#include    <mbbiDirectRecord.h>
#include    <mbboRecord.h>
#include    <mbboDirectRecord.h>

#include "alarm.h"
#include "cvtTable.h"
#include "dbDefs.h"
#include "dbAccess.h"
#include "dbEvent.h"
#include "recSup.h"
#include "devSup.h"
#include "dbScan.h"
#include "link.h"
#include "Hy8513.h"

int getioscanpvt(const int cardnum, IOSCANPVT *scanpvt);

static long init(void);

static long init_ai(struct aiRecord *pai);
static long init_ao(struct aoRecord *pao);
static long init_mbbidirect(struct mbbiDirectRecord *mbbi);

static long read_ai(struct aiRecord *pai);
static long write_ao(struct aoRecord *pao);
static long read_mbbidirect(struct mbbiDirectRecord *mbbi);

long DevHy8513Report(void);

/* static long ai_get_ioint_info(int cmd, struct aiRecord *p, IOSCANPVT *pvt); */
static long mbbi_get_ioint_info(int cmd, struct mbbiDirectRecord *p, IOSCANPVT *pvt);

static long ai_linconv(struct aiRecord	*pai, int after);
static long ao_linconv(struct aoRecord	*pao, int after);

long Hy8513_ai_driver(const int card, const short signal, const char *parm, int *value);
long Hy8513_ao_driver(const int card, const short signal, const char *parm, int value);
long Hy8513_mbbidirect_driver(const int card, const short signal, const char *parm, int *value);

#define MAXVAL	(0x7fffffff)

typedef struct dev_sup
{
	long		number;
	DEVSUPFUN	report;
	DEVSUPFUN	init;
	DEVSUPFUN	init_record;
	DEVSUPFUN	get_ioint_info;
	DEVSUPFUN	read_write;
	DEVSUPFUN	linconv;
} devHy8513Sup;

devHy8513Sup devAoHy8513 =
{
	6,
	DevHy8513Report,
	init,
	init_ao,
	NULL,
	write_ao,
	ao_linconv
};

devHy8513Sup devAiHy8513 =
{
	6,
	DevHy8513Report,
	NULL,
	init_ai,
	NULL,
	read_ai,
	ai_linconv
};

devHy8513Sup devMbbiDirectHy8513 =
{
	6,
	NULL,
	NULL,
	init_mbbidirect,
	mbbi_get_ioint_info,
	read_mbbidirect,
	NULL
};


/**********************************************************

    NAME:			DevHy8513Report()
    
    Description:
        
    Function - 

            
    Parameters:
                
    Inputs:			None.
    Outputs:        None.
    Return:			0 - Everything OK

                            
    Notes:
                            
    Programmer(s):  Darrell Nineham
                    Paul Hamadyk

**********************************************************

 Revision History
 ----------------

 Date            By      Version     Descripition
 ----            --      -------     ------------
 18-NOV-2004     DAN     1.2         Upgraded to Hytec
                                     coding standard.

 25-JUN-2004     PH      1.1         Intial Version by
                                     Paul Hamadyk Checked
                                     in by Darrell Nineham.

**********************************************************/
long DevHy8513Report(void)
{
	puts("Hy8513Device report");
	
	return (0);
}


/**********************************************************

    NAME:			init()
    
    Description:
        
    Function - 

            
    Parameters:
                
    Inputs:			None.
    Outputs:        None.
    Return:			0 - Everything OK
                            
    Notes:
                            
    Programmer(s):  Darrell Nineham
                    Paul Hamadyk

**********************************************************

 Revision History
 ----------------

 Date            By      Version     Descripition
 ----            --      -------     ------------
 18-NOV-2004     DAN     1.2         Upgraded to Hytec
                                     coding standard.

 25-JUN-2004     PH      1.1         Intial Version by
                                     Paul Hamadyk Checked
                                     in by Darrell Nineham.

**********************************************************/
static long init(void)
{

#ifdef DEBUG

	puts("devHy8513 init");

#endif
	
	return (0);
}


/**********************************************************

    NAME:			init_ai()
    
    Description:
        
    Function - 

            
    Parameters:
                
    Inputs:			*pai - 
    Outputs:        None.
    Return:			0 - Everything OK
                            
    Notes:
                            
    Programmer(s):  Darrell Nineham
                    Paul Hamadyk

**********************************************************

 Revision History
 ----------------

 Date            By      Version     Descripition
 ----            --      -------     ------------
 18-NOV-2004     DAN     1.2         Upgraded to Hytec
                                     coding standard.

 25-JUN-2004     PH      1.1         Intial Version by
                                     Paul Hamadyk Checked
                                     in by Darrell Nineham.

**********************************************************/
static long init_ai(struct aiRecord *pai)
{
	
	/* ai.inp must be an VME_IO */

	switch (pai->inp.type)
	{
		case (VME_IO):
		{
			break;
		}
		
		default:
		{
			recGblRecordError(S_db_badField, (void *) pai, "devHy8513 (init_record) Illegal INP field");
			return (S_db_badField);
		}
	}

	/* set linear conversion slope */

	pai->eslo = (pai->eguf - pai->egul) / MAXVAL;

	return(0);
}


/**********************************************************

    NAME:			read_ai()
    
    Description:
        
    Function - 

            
    Parameters:
                
    Inputs:			*pai - 
    Outputs:        None.
    Return:			0 - Everything OK
                            
    Notes:
                            
    Programmer(s):  Darrell Nineham
                    Paul Hamadyk

**********************************************************

 Revision History
 ----------------

 Date            By      Version     Descripition
 ----            --      -------     ------------
 18-NOV-2004     DAN     1.2         1. Fixed bug (found by
									 Paul Hamadyk) rounding 
									 rval.
									 2. Fixed bug (found by
									 Paul Hamadyk) must return
									 0 to allow conversion by
									 EGUF and EGUL.
									 3. Upgraded to Hytec
                                     coding standard.

 25-JUN-2004     PH      1.1         Intial Version by
                                     Paul Hamadyk Checked
                                     in by Darrell Nineham.

**********************************************************/
static long read_ai(struct aiRecord *pai)
{
	struct vmeio *pvmeio;
	long status;
	int value;
	
	pvmeio = (struct vmeio *) &(pai->inp.value);
	
	status = Hy8513_ai_driver(pvmeio->card, pvmeio->signal, pvmeio->parm, &value);
	
	if (status == 0)
	{
		pai->rval = value;
	}
	else
	{
		recGblSetSevr(pai, READ_ALARM, INVALID_ALARM);
	}
	
	return (0);
}


/**********************************************************

    NAME:			ai_linconv()
    
    Description:
        
    Function - 

            
    Parameters:
                
    Inputs:			*pai	- 
					after	-
    Outputs:        None.
    Return:			0 - Everything OK
                            
    Notes:
                            
    Programmer(s):  Darrell Nineham
                    Paul Hamadyk

**********************************************************

 Revision History
 ----------------

 Date            By      Version     Descripition
 ----            --      -------     ------------
 18-NOV-2004     DAN     1.2         Upgraded to Hytec
                                     coding standard.

 25-JUN-2004     PH      1.1         Intial Version by
                                     Paul Hamadyk Checked
                                     in by Darrell Nineham.

**********************************************************/
static long ai_linconv(struct aiRecord	*pai, int after)
{
	if (!after)
	{
		return (0);
	}
	
	/* set linear conversion slope*/

	pai->eslo = (pai->eguf - pai->egul) / MAXVAL;
	
	return (0);
}


/**********************************************************

    NAME:			init_ao()
    
    Description:
        
    Function - 

            
    Parameters:
                
    Inputs:			*pao	- 
    Outputs:        None.
    Return:			0 - Everything OK
                            
    Notes:
                            
    Programmer(s):  Darrell Nineham
                    Paul Hamadyk

**********************************************************

 Revision History
 ----------------

 Date            By      Version     Descripition
 ----            --      -------     ------------
 18-NOV-2004     DAN     1.2         Upgraded to Hytec
                                     coding standard.

 25-JUN-2004     PH      1.1         Intial Version by
                                     Paul Hamadyk Checked
                                     in by Darrell Nineham.

**********************************************************/
static long init_ao(struct aoRecord *pao)
{
	
	/* ao.out must be an VME_IO */

	switch (pao->out.type)
	{
		case (VME_IO):
		{
			break;
		}
		
		default:
		{
			recGblRecordError(S_db_badField, (void *) pao, "devHy8513 (init_record) Illegal OUT field");
			return(S_db_badField);
		}
	}

	/* set linear conversion slope */
	
	pao->eslo = (pao->eguf - pao->egul) / MAXVAL;
	
	return (0);
}


/**********************************************************

    NAME:			write_ao()
    
    Description:
        
    Function - 

            
    Parameters:
                
    Inputs:			*pao - 
    Outputs:        None.
    Return:	
                            
    Notes:
                            
    Programmer(s):  Darrell Nineham
                    Paul Hamadyk

**********************************************************

 Revision History
 ----------------

 Date            By      Version     Descripition
 ----            --      -------     ------------
 18-NOV-2004     DAN     1.2         Upgraded to Hytec
                                     coding standard.

 25-JUN-2004     PH      1.1         Intial Version by
                                     Paul Hamadyk Checked
                                     in by Darrell Nineham.

**********************************************************/
static long write_ao(struct aoRecord *pao)
{
	struct vmeio *pvmeio;
	long status;
	int value = (int) pao->rval;
	
	pvmeio = (struct vmeio *) &(pao->out.value);

	status = Hy8513_ao_driver(pvmeio->card, pvmeio->signal, pvmeio->parm, value);

	if (status != 0)
	{
		recGblSetSevr(pao, WRITE_ALARM, INVALID_ALARM);
	}
		
	return (status);
}


/**********************************************************

    NAME:			ao_linconv()
    
    Description:
        
    Function - 

            
    Parameters:
                
    Inputs:			*pao	- 
					after	-
    Outputs:        None.
    Return:			0 - Everything OK
                            
    Notes:
                            
    Programmer(s):  Darrell Nineham
                    Paul Hamadyk

**********************************************************

 Revision History
 ----------------

 Date            By      Version     Descripition
 ----            --      -------     ------------
 18-NOV-2004     DAN     1.2         Upgraded to Hytec
                                     coding standard.

 25-JUN-2004     PH      1.1         Intial Version by
                                     Paul Hamadyk Checked
                                     in by Darrell Nineham.

**********************************************************/
static long ao_linconv(struct aoRecord	*pao, int after)
{
	if (!after)
	{
		return (0);
	}
	
	/* set linear conversion slope*/

	pao->eslo = (pao->eguf - pao->egul) / MAXVAL;
	
	return (0);
}


/**********************************************************

    NAME:			init_mbbidirect()
    
    Description:
        
    Function - 

            
    Parameters:
                
    Inputs:			*mbbi - 
    Outputs:        None.
    Return:			0 - Everything OK
                            
    Notes:
                            
    Programmer(s):  Darrell Nineham
                    Paul Hamadyk

**********************************************************

 Revision History
 ----------------

 Date            By      Version     Descripition
 ----            --      -------     ------------
 18-NOV-2004     DAN     1.2         Upgraded to Hytec
                                     coding standard.

 25-JUN-2004     PH      1.1         Intial Version by
                                     Paul Hamadyk Checked
                                     in by Darrell Nineham.

**********************************************************/
static long init_mbbidirect(struct mbbiDirectRecord *mbbi)
{
	
	/* .inp must be an VME_IO */

	switch (mbbi->inp.type)
	{
		case (VME_IO):
		{
		/*	mbbi->shft = mbbi->inp.value.vmeio.signal; */
			mbbi->mask <<= mbbi->shft;

			break;
		}
		
		default:
		{
			recGblRecordError(S_db_badField, (void *) mbbi, "devHy8513 (init_record) Illegal OUT field");
			return(S_db_badField);
		}
	}

	return (0);
}



/**********************************************************

    NAME:			read_mbbidirect()
    
    Description:
        
    Function - 

            
    Parameters:
                
    Inputs:			*mbbi - 
    Outputs:        None.
    Return:	
                            
    Notes:
                            
    Programmer(s):  Darrell Nineham
                    Paul Hamadyk

**********************************************************

 Revision History
 ----------------

 Date            By      Version     Descripition
 ----            --      -------     ------------
 18-NOV-2004     DAN     1.2         Upgraded to Hytec
                                     coding standard.

 25-JUN-2004     PH      1.1         Intial Version by
                                     Paul Hamadyk Checked
                                     in by Darrell Nineham.

**********************************************************/
static long read_mbbidirect(struct mbbiDirectRecord *mbbi)
{
	struct vmeio *pvmeio;
	long status;
	int value;
	
	pvmeio = (struct vmeio *) &(mbbi->inp.value);

	status = Hy8513_mbbidirect_driver(pvmeio->card, pvmeio->signal, pvmeio->parm, &value);

	if (status == 0)
	{
		mbbi->rval = value & mbbi->mask;
	}
	else
	{
		recGblSetSevr(mbbi, READ_ALARM, INVALID_ALARM);
	}
	
	return (status);
}



/**********************************************************

    NAME:  mbbi_get_ioint_info()
    
    Description:
        
    Function - for interrupts on index pulse 


            
    Parameters:
                
    Inputs:			cmd		-
					*p		-
					*ppvt	-

    Outputs:        None.

    Return:			0 - Everything OK
                            
    Notes:
                            
    Programmer(s):  Darrell Nineham
                    Paul Hamadyk

**********************************************************

 Revision History
 ----------------

 Date            By      Version     Descripition
 ----            --      -------     ------------
 18-NOV-2004     DAN     1.2         Upgraded to Hytec
                                     coding standard.

 25-JUN-2004     PH      1.1         Intial Version by
                                     Paul Hamadyk Checked
                                     in by Darrell Nineham.

**********************************************************/
static long mbbi_get_ioint_info(int cmd, struct mbbiDirectRecord *p, IOSCANPVT *ppvt)
{
	getioscanpvt(p->inp.value.vmeio.card, ppvt);

	return (0);
}
