/**********************************************************
   A Small Set of Routines to Test the drvHy8513 Module
   ----------------------------------------------------

   Description -

   A small module that calls the drvHy8513 layer directly.
   

   Version - 

   $Id: test8513.c,v 1.2 2005/02/02 10:57:49 cross Exp $
   

   History -
   
    
   Initial Version - Darrell Nineham, Hytec Electronics Ltd.


***********************************************************/


/**********************************************************
    
    Function - test()

    Description - 

    Simulates Encoder Movements using Test bit in CSR....

	1. Display Present Registers.  
	2. Then 'Move it' the passed NumberOfSteps.
	3. Display Updated Registers.  
    
***********************************************************/
int test(int WhichCard, int NumberOfSteps) 
{
    int ScalerCount;

    for(ScalerCount = 0; ScalerCount < 4; ScalerCount++)
    {
        Hy8513_ao_driver(WhichCard, ScalerCount,"NU",0xFFFFFFF0);         
    }

    /* Display Hy8513 Registers (Decimal) before Test Move */
    DrvHy8513Report(1);

    TestCount(WhichCard,NumberOfSteps);
    
    /* Display Hy8513 Registers (Decimal) Post Move */
    DrvHy8513Report(1);

    return 0;
}


/**********************************************************
    
    Function - show()



	Short Cut to Display Present Registers.  
    
***********************************************************/
int show(int DisplayLevel) 
{
    /* Display Hy8513 Registers */
    DrvHy8513Report(DisplayLevel);
    
    return 0;
}

